/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.BreakIterator;
import java.util.Locale;

public class TextWrapper {
    private static final Dimension DEFAULT_SIZE = new Dimension(0, 0);
    int offset;
    int endOffset;
    int lineOffset;
    int lineLength;
    int lineWidth;
    char[] text;
    FontMetrics fm;
    int maxWidth;
    BreakIterator brkIter;
    Dimension m_preferredSize = DEFAULT_SIZE;
    Dimension m_minimumSize = DEFAULT_SIZE;
    int m_textLines = 0;

    public TextWrapper(String string, int n, FontMetrics fontMetrics, Locale locale) {
        this.maxWidth = n;
        this.fm = fontMetrics;
        this.brkIter = BreakIterator.getLineInstance(locale);
        this.setText(string);
    }

    public void setText(String string) {
        string = string == null ? "" : string.trim();
        this.text = string.toCharArray();
        this.brkIter.setText(string);
        this.offset = 0;
        this.endOffset = string.length();
        this.calculateStatistics();
    }

    public String nextLine() {
        this.advanceLine();
        return new String(this.text, this.lineOffset, this.lineLength);
    }

    public void advanceLine() {
        this.lineWidth = 0;
        int n = this.lineOffset = this.offset;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            this.offset = this.brkIter.next();
            if (this.offset == -1) {
                this.offset = this.brkIter.last();
                break;
            }
            int n4 = -1;
            n3 = 0;
            int n5 = this.offset - 1;
            int n6 = this.text[n5];
            while (Character.isWhitespace((char)n6)) {
                if (n6 == 10 || n6 == 13) {
                    n4 = n5;
                }
                ++n3;
                n6 = this.text[--n5];
            }
            if (n4 != -1) break;
            n5 = this.fm.charsWidth(this.text, this.lineOffset, this.offset - this.lineOffset - n3);
            if (n5 > this.maxWidth) {
                if (this.lineOffset >= n) break;
                this.offset = n;
                n3 = n2;
                n6 = this.brkIter.previous();
                break;
            }
            n = this.offset;
            n2 = n3;
            n3 = 0;
            this.lineWidth = n5;
        }
        this.lineLength = this.offset - this.lineOffset - n3;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.m_preferredSize);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.m_minimumSize);
    }

    public int textLines() {
        return this.m_textLines;
    }

    public void paint(Graphics graphics) {
        this.paintLeftJustified(graphics, 0, 0);
    }

    public synchronized void paintLeftJustified(Graphics graphics, int n, int n2) {
        this.reset();
        n2 += this.fm.getAscent();
        int n3 = this.fm.getHeight();
        while (this.hasMoreLines()) {
            this.advanceLine();
            graphics.drawChars(this.text, this.lineOffset, this.lineLength, n, n2);
            n2 += n3;
        }
    }

    public boolean hasMoreLines() {
        return this.offset < this.endOffset;
    }

    public synchronized void paintRightJustified(Graphics graphics, int n, int n2, int n3) {
        this.reset();
        n2 += this.fm.getAscent();
        int n4 = this.fm.getHeight();
        while (this.hasMoreLines()) {
            this.advanceLine();
            int n5 = n + n3 - this.fm.charsWidth(this.text, this.lineOffset, this.lineLength);
            graphics.drawChars(this.text, this.lineOffset, this.lineLength, n5, n2);
            n2 += n4;
        }
    }

    public synchronized void paintCentered(Graphics graphics, int n, int n2, int n3) {
        this.reset();
        n2 += this.fm.getAscent();
        int n4 = this.fm.getHeight();
        while (this.hasMoreLines()) {
            this.advanceLine();
            int n5 = n + (n3 - this.fm.charsWidth(this.text, this.lineOffset, this.lineLength)) / 2;
            graphics.drawChars(this.text, this.lineOffset, this.lineLength, n5, n2);
            n2 += n4;
        }
    }

    public synchronized void reset() {
        this.offset = this.brkIter.first();
        this.lineOffset = 0;
        this.lineLength = 0;
        this.lineWidth = 0;
    }

    public synchronized int getMinimumWidth() {
        int n = 0;
        this.reset();
        int n2 = this.offset;
        while (true) {
            this.offset = this.brkIter.next();
            if (this.offset == -1) break;
            n = Math.max(this.fm.charsWidth(this.text, this.lineOffset, this.offset - n2), n);
            n2 = this.offset;
        }
        if (n == 0) {
            n = this.fm.charsWidth(this.text, 0, this.text.length);
        }
        return n;
    }

    public synchronized void adjustWidth() {
        this.maxWidth = Math.max(this.maxWidth, this.getMinimumWidth());
        this.calculateStatistics();
    }

    public synchronized void setFontMetrics(FontMetrics fontMetrics) {
        this.fm = fontMetrics;
        this.reset();
        this.calculateStatistics();
    }

    private void calculateStatistics() {
        if (this.fm != null && this.text != null) {
            this.calculateTextLines();
            this.calculatePreferredSize();
            this.calculateMinimumSize();
        }
    }

    private void calculateTextLines() {
        this.reset();
        int n = 0;
        while (this.hasMoreLines()) {
            ++n;
            this.advanceLine();
        }
        this.m_textLines = n;
    }

    private void calculatePreferredSize() {
        Dimension dimension = this.fm != null ? new Dimension(this.maxWidth, this.textLines() * this.fm.getHeight()) : DEFAULT_SIZE;
        this.m_preferredSize = dimension;
    }

    private void calculateMinimumSize() {
        Dimension dimension;
        if (this.fm != null) {
            this.reset();
            int n = 0;
            int n2 = 0;
            while (this.hasMoreLines()) {
                ++n;
                this.advanceLine();
                n2 = Math.max(n2, this.lineWidth);
            }
            dimension = new Dimension(n2, n * this.fm.getHeight());
        } else {
            dimension = DEFAULT_SIZE;
        }
        this.m_minimumSize = dimension;
    }
}

